import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/core/errors/failure.dart';
import 'package:razinsoft_rider/data/models/create_order_response/create_order_response.dart';
import 'package:razinsoft_rider/data/models/order_response/order_detail/order_detail_model.dart';
import 'package:razinsoft_rider/data/models/order_response/tip_model/trip_model.dart';
import 'package:razinsoft_rider/data/repositories/interfaces/order_repo_interface.dart';

import '../../domain/interfaces/order_service_interface.dart';
import 'base_repository.dart';

class OrderRepoImpl extends BaseRepository implements IOrderRepo {
  final IOrderService orderService;

  OrderRepoImpl(this.orderService);
  @override
  Future<Either<Failure, CreateOrderResponse>> createOrder({required Map<String, dynamic> data}) async => await safeApiCall(() async {
      final response = await orderService.createOrder(data: data);
       return CreateOrderResponse.fromJson(response.data);
    });

  @override
  Future<Either<Failure, OrderDetailModel>> orderDetails({required int orderId}) async => await safeApiCall(() async {
      final response = await orderService.orderDetails(orderId: orderId);
     try{
       return OrderDetailModel.fromJson(response.data);
     }catch(e){
       return OrderDetailModel.fromJson(response.data);
     }
    });

  @override
  Future<Either<Failure, TripModel>> checkActiveTrip() async => await safeApiCall(() async {
      final response = await orderService.checkActiveTrip();
      try{
        return TripModel.fromJson(response.data);
      }catch(e){
        return TripModel.fromJson(response.data);
      }
    });

}

